;Quatz 4,00 Mhz	
;Pic16f84
;XT - Mode
;PowerOn Reset Enable
;WatchdogTimer Disable

	ERRORLEVEL -302

#include "P16f84.inc"

	LIST   P=PIC16F84

;Adresse im RAM wo die Impulsdauer gespeichert wird
S1	EQU	0Dh
S2	EQU	0Eh
S3	EQU	0Fh

;Adresse fr Interrupt Flag
FLAG	EQU	010h

;STACK fr W-Register
STACKW	EQU	011h

	org 	00h
	goto	start

	org	04h
	goto	int

start				;Initialisierung
	clrf	PORTA		;Ports rcksetzten
	clrf 	PORTB
	bsf	STATUS, RP0	;Bank1
	clrf	OPTION_REG
	bsf	OPTION_REG, 7	;Pull up disablen
	movlw	03h		;PA0-PA1 Eingang
	movwf	TRISA		;PA2-PA4 Ausgang
	movlw	0FFh
	movwf	TRISB		;PORTB Eingang
	bcf	STATUS, RP0	;Bank 0 
	clrf	FLAG		;Flagregister lschen
	movlw	080h		;Servo in Mittelstellung
	movwf	S1
	movwf	S2
	movwf	S3
	bsf	FLAG, 1		;Interrupt Flag "alles low"
	movlw	0A0h		;nur Timerberlauf als Interrupt
	movwf	INTCON		;
	clrf 	TMR0		;Timer rcksetzen

loop	movf	PORTA, 0	;PORTA nach W kopieren
	movwf	FSR		;und weiter ins FSR
	movlw	03h		;dort maskieren und
	andwf	FSR, 1		;nur untere 2 Bits lassen
	movlw	0Ch		;RAM Startadresse ins W und
	addwf	FSR, 1		;zur Adresse im FSR addieren
				;Das ergibt dann das je nach Zustand
				;von PortA einen Offset im RAM
	movf	PORTB, 0	;und dann wird an die so entstandene Adresse
	movwf	INDF		;der Wert von Port B indirekt kopiert
	goto 	loop		;Endlosschleife

int	movwf	STACKW		;W auf Stack retten
	btfsc	FLAG, 1
	goto	INT1
	btfsc	FLAG, 2
	goto	INT2
	btfsc	FLAG, 3
	goto	INT3
	btfsc	FLAG, 4
	goto	INT4
	btfsc	FLAG, 5
	goto	INT5
	btfsc	FLAG, 6
	goto	INT6
	goto	INT7

;Zustand "alles low" -> "S1 Vorimpuls"
INT1	bsf	PORTA, 2	;low - setzte high
	movlw	0E1h		;Vorimpuls 0,5 ms
	movwf	TMR0		;0,48 ms
	movlw	04h		;Interruptflag "S1 Vorimpuls"		
	movwf	FLAG
	bsf	STATUS, RP0	;Bank1
	movlw	083h		;Teiler 1:16
	goto	intret		;Zum Interruptreturn springen

;Zustand "S1 Vorimpuls" -> "S1 Hauptimpuls"
INT2	movf	S1, 0		;Impuls erzeugen
	sublw	0FFh
	movwf	TMR0		;Impulslnge
	movlw	08h		;Interruptflag "S1 Hauptimpuls"		
	movwf	FLAG
	bsf	STATUS, RP0	;Bank1
	movlw	082h		;Teiler 1:8
	goto	intret		;Zum Interruptreturn springen

;S1 Hauptimpuls
INT3	bcf	PORTA, 2
	bsf	PORTA, 3	;low - setzte high
	movlw	0E1h		;Vorimpuls 0,5 ms
	movwf	TMR0		;
	movlw	010h		;Interruptflag "S2 Vorimpuls"		
	movwf	FLAG
	bsf	STATUS, RP0	;Bank1
	movlw	083h		;Teiler 1:16
	goto	intret		;Zum Interruptreturn springen

;S2 Vorimpuls
INT4	movf	S2, 0		;Impuls erzeugen

	sublw	0FFh
	movwf	TMR0		;Impulslnge
	movlw	020h		;Interruptflag "S2 Hauptimpuls"		
	movwf	FLAG
	bsf	STATUS, RP0	;Bank1
	movlw	082h		;Teiler 1:8
	goto	intret		;Zum Interruptreturn springen

;S2 Hauptimpuls
INT5	bcf	PORTA, 3
	bsf	PORTA, 4	;low - setzte high
	movlw	0E1h		;Vorimpuls 0,5 ms
	movwf	TMR0		;
	movlw	040h		;Interruptflag "S3 Vorimpuls"		
	movwf	FLAG
	bsf	STATUS, RP0	;Bank1
	movlw	083h		;Teiler 1:16
	goto	intret		;Zum Interruptreturn springen

;S3 Vorimpuls
INT6	movf	S3, 0		;Impuls erzeugen
	sublw	0FFh
	movwf	TMR0		;Impulslnge
	movlw	080h		;Interruptflag "S3 Hauptimpuls"		
	movwf	FLAG
	bsf	STATUS, RP0	;Bank1
	movlw	082h		;Teiler 1:8
	goto	intret		;Zum Interruptreturn springen

;S3 Hauptimpuls
INT7	bcf	PORTA, 4	;high -setzte low
	movlw	0CDh		;
	movwf	TMR0		;Zeit Einstellen
	movlw	02h		;Interruptflag "alles Low"		
	movwf	FLAG
	BSF	STATUS, RP0	;Bank1
	movlw	087h		;Teiler 1:256

;gemeinsammes Ende des Int.
;Zhler laden, bank wechseln, W vom Stack zurck
intret	movwf	OPTION_REG	;
	bcf	STATUS, RP0	; Bank 0
	bcf	INTCON, T0IF
	movf	STACKW, 0	; W zurckholen aus Stack
	retfie

	END
